jQuery(function ($) {

    var COUNTRY_MAP_3_ISO = {
        'AF': 'AFG',
        'AL': 'ALB',
        'DZ': 'DZA',
        'AS': 'ASM',
        'AD': 'AND',
        'AO': 'AGO',
        'AI': 'AIA',
        'AQ': 'ATA',
        'AG': 'ATG',
        'AR': 'ARG',
        'AM': 'ARM',
        'AW': 'ABW',
        'AU': 'AUS',
        'AT': 'AUT',
        'AZ': 'AZE',
        'BS': 'BHS',
        'BH': 'BHR',
        'BD': 'BGD',
        'BB': 'BRB',
        'BY': 'BLR',
        'BE': 'BEL',
        'BZ': 'BLZ',
        'BJ': 'BEN',
        'BM': 'BMU',
        'BT': 'BTN',
        'BO': 'BOL',
        'BQ': 'BES',
        'BA': 'BIH',
        'BW': 'BWA',
        'BV': 'BVT',
        'BR': 'BRA',
        'IO': 'IOT',
        'BN': 'BRN',
        'BG': 'BGR',
        'BF': 'BFA',
        'BI': 'BDI',
        'KH': 'KHM',
        'CM': 'CMR',
        'CA': 'CAN',
        'CV': 'CPV',
        'KY': 'CYM',
        'CF': 'CAF',
        'TD': 'TCD',
        'CL': 'CHL',
        'CN': 'CHN',
        'CX': 'CXR',
        'CC': 'CCK',
        'CO': 'COL',
        'KM': 'COM',
        'CG': 'COG',
        'CD': 'COD',
        'CK': 'COK',
        'CR': 'CRI',
        'HR': 'HRV',
        'CU': 'CUB',
        'CW': 'CUW',
        'CY': 'CYP',
        'CZ': 'CZE',
        'CI': 'CIV',
        'DK': 'DNK',
        'DJ': 'DJI',
        'DM': 'DMA',
        'DO': 'DOM',
        'EC': 'ECU',
        'EG': 'EGY',
        'SV': 'SLV',
        'GQ': 'GNQ',
        'ER': 'ERI',
        'EE': 'EST',
        'ET': 'ETH',
        'FK': 'FLK',
        'FO': 'FRO',
        'FJ': 'FJI',
        'FI': 'FIN',
        'FR': 'FRA',
        'GF': 'GUF',
        'PF': 'PYF',
        'TF': 'ATF',
        'GA': 'GAB',
        'GM': 'GMB',
        'GE': 'GEO',
        'DE': 'DEU',
        'GH': 'GHA',
        'GI': 'GIB',
        'GR': 'GRC',
        'GL': 'GRL',
        'GD': 'GRD',
        'GP': 'GLP',
        'GU': 'GUM',
        'GT': 'GTM',
        'GG': 'GGY',
        'GN': 'GIN',
        'GW': 'GNB',
        'GY': 'GUY',
        'HT': 'HTI',
        'HM': 'HMD',
        'VA': 'VAT',
        'HN': 'HND',
        'HK': 'HKG',
        'HU': 'HUN',
        'IS': 'ISL',
        'IN': 'IND',
        'ID': 'IDN',
        'IR': 'IRN',
        'IQ': 'IRQ',
        'IE': 'IRL',
        'IM': 'IMN',
        'IL': 'ISR',
        'IT': 'ITA',
        'JM': 'JAM',
        'JP': 'JPN',
        'JE': 'JEY',
        'JO': 'JOR',
        'KZ': 'KAZ',
        'KE': 'KEN',
        'KI': 'KIR',
        'KP': 'PRK',
        'KR': 'KOR',
        'KW': 'KWT',
        'KG': 'KGZ',
        'LA': 'LAO',
        'LV': 'LVA',
        'LB': 'LBN',
        'LS': 'LSO',
        'LR': 'LBR',
        'LY': 'LBY',
        'LI': 'LIE',
        'LT': 'LTU',
        'LU': 'LUX',
        'MO': 'MAC',
        'MK': 'MKD',
        'MG': 'MDG',
        'MW': 'MWI',
        'MY': 'MYS',
        'MV': 'MDV',
        'ML': 'MLI',
        'MT': 'MLT',
        'MH': 'MHL',
        'MQ': 'MTQ',
        'MR': 'MRT',
        'MU': 'MUS',
        'YT': 'MYT',
        'MX': 'MEX',
        'FM': 'FSM',
        'MD': 'MDA',
        'MC': 'MCO',
        'MN': 'MNG',
        'ME': 'MNE',
        'MS': 'MSR',
        'MA': 'MAR',
        'MZ': 'MOZ',
        'MM': 'MMR',
        'NA': 'NAM',
        'NR': 'NRU',
        'NP': 'NPL',
        'NL': 'NLD',
        'NC': 'NCL',
        'NZ': 'NZL',
        'NI': 'NIC',
        'NE': 'NER',
        'NG': 'NGA',
        'NU': 'NIU',
        'NF': 'NFK',
        'MP': 'MNP',
        'NO': 'NOR',
        'OM': 'OMN',
        'PK': 'PAK',
        'PW': 'PLW',
        'PS': 'PSE',
        'PA': 'PAN',
        'PG': 'PNG',
        'PY': 'PRY',
        'PE': 'PER',
        'PH': 'PHL',
        'PN': 'PCN',
        'PL': 'POL',
        'PT': 'PRT',
        'PR': 'PRI',
        'QA': 'QAT',
        'RO': 'ROU',
        'RU': 'RUS',
        'RW': 'RWA',
        'RE': 'REU',
        'BL': 'BLM',
        'SH': 'SHN',
        'KN': 'KNA',
        'LC': 'LCA',
        'MF': 'MAF',
        'PM': 'SPM',
        'VC': 'VCT',
        'WS': 'WSM',
        'SM': 'SMR',
        'ST': 'STP',
        'SA': 'SAU',
        'SN': 'SEN',
        'RS': 'SRB',
        'SC': 'SYC',
        'SL': 'SLE',
        'SG': 'SGP',
        'SX': 'SXM',
        'SK': 'SVK',
        'SI': 'SVN',
        'SB': 'SLB',
        'SO': 'SOM',
        'ZA': 'ZAF',
        'GS': 'SGS',
        'SS': 'SSD',
        'ES': 'ESP',
        'LK': 'LKA',
        'SD': 'SDN',
        'SR': 'SUR',
        'SJ': 'SJM',
        'SZ': 'SWZ',
        'SE': 'SWE',
        'CH': 'CHE',
        'SY': 'SYR',
        'TW': 'TWN',
        'TJ': 'TJK',
        'TZ': 'TZA',
        'TH': 'THA',
        'TL': 'TLS',
        'TG': 'TGO',
        'TK': 'TKL',
        'TO': 'TON',
        'TT': 'TTO',
        'TN': 'TUN',
        'TR': 'TUR',
        'TM': 'TKM',
        'TC': 'TCA',
        'TV': 'TUV',
        'UG': 'UGA',
        'UA': 'UKR',
        'AE': 'ARE',
        'GB': 'GBR',
        'US': 'USA',
        'UM': 'UMI',
        'UY': 'URY',
        'UZ': 'UZB',
        'VU': 'VUT',
        'VE': 'VEN',
        'VN': 'VNM',
        'VG': 'VGB',
        'VI': 'VIR',
        'WF': 'WLF',
        'EH': 'ESH',
        'YE': 'YEM',
        'ZM': 'ZMB',
        'ZW': 'ZWE'
    };
    
    var needsReload = false;

    $("#stype").change(function () {
        $("#is_cod").attr("value", $(this).val());
    });

    $('#trackingModal').off('hidden.bs.modal').on('hidden.bs.modal', function (e) {
        e.preventDefault();
        e.stopPropagation();
        return false;
    });
    
    $('#myModal').off('hidden.bs.modal').on('hidden.bs.modal', function () {
        $("#newone").addClass('hidden');
        $("#next").addClass('hidden');
        $("#booked").addClass('hidden');
        $("#getset").removeClass('hidden');
        $("#details").addClass('hidden');
        $("#bsuccess").addClass('hidden');
        // $("#newone").addClass('hidden');
        $("#newtwo").addClass('hidden');
        $("#warehouses").removeClass('hidden');
        $('.proceed0').removeClass('hidden');
        $('.proceed1').addClass('hidden');
        $('#iscod').addClass('hidden');
        if(needsReload) {
            location.reload();
        }
    });

    $(".rtbtn").click(function () {
        $(".just").remove();
        var is_cod = 'cod' == $(this).attr('is_cod');
        var pymt = is_cod ? $("#stype option[id='cod']") : $("#stype option[id='prepaid']");
        $(".addcheck").remove();
        $("#newone").removeClass('hidden');
        $("#getset").addClass('hidden');
        $("#length").attr("value", $(this).attr("count"));
        $("#fname").attr("value", $(this).attr("firstname"));
        $("#lname").attr("value", $(this).attr("lastname"));
        $("#parcel_content").attr("value", $(this).attr("content"));
        $("#receiver_company").attr("value", $(this).attr("company"));
        $("#receiver_shipadd1").attr("value", $(this).attr("shipaddone"));
        $("#receiver_shipadd2").attr("value", $(this).attr("shipaddtwo"));
        $("#receiver_phone").attr("value", $(this).attr("phone"));
        $("#receiver_city").attr("value", $(this).attr("city"));
        $("#receiver_state").attr("value", $(this).attr("state"));
        $("#receiver_country").attr("value", $(this).attr("country"));
        $("#delivery_pincode").attr("value", $(this).attr("pin"));
        $("#oid").attr("value", $(this).attr("oid"));
        $("#data").attr("value", $(this).attr("data"));
        $("#content").attr("value", $(this).attr("content"));
        $('#is_cod').attr('value', is_cod);
        pymt.attr("selected", "selected");
        var apikey = $("#custom_data").attr("key");
        var code = $("#custom_data").attr("code");
        var count = $(this).attr("count");
        $("#count").attr("value", count);
        var content = $(this).attr('content');
        var data = $(this).attr('data');
        var array = content.split(',');
        var array1 = data.split(',');
        var j = 0;

        var settings = {
            "async": true,
            "crossDomain": true,
            "url": "//" + code + "/api/v1/customers/info/",
            "method": "GET",
            "headers": {
                "x-api-token": "" + apikey + "",
                "content-type": "application/json",
                "cache-control": "no-cache"
            }
        };
        $.ajax(settings).done(function (response) {

            $('#fixed_address').attr('value', response['user_info'].fixed_address);
            $("#warehouses").append("<div class='addcheck'  name='" + response['user_info']['primary_contact'][0] + "' pcompany_name='" + response['user_info']['address'].company_name + "' pphone='" + response['user_info']['primary_phone'][0] + "' ppincode='" + response['user_info'].pincode + "' pstreet1='" + response['user_info']['address'].street1 + "' pstreet2='" + response['user_info']['address'].street2 + "' style='background-color:white; border-style: inset; cursor:pointer;'>&nbsp" + response['user_info']['primary_contact'][0] + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + response['user_info']['address'].company_name + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + response['user_info']['primary_phone'][0] + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + response['user_info'].pincode + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + response['user_info']['address'].street1 + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + response['user_info']['address'].street2 + "</div>");
            if (response['user_info'].fixed_address == false) {
                $.each(response['user_info']['business_info']['warehouses'], function (index2, value2) {
                    $("#warehouses").append("<div class='addcheck' name='" + value2.name + "' pcompany_name='" + value2.company_name + "' pphone='" + value2.phone + "' ppincode='" + value2.pincode + "' pstreet1='" + value2.street1 + "' pstreet2='" + value2.street2 + "' style='background-color:white; border-style: inset;'>&nbsp" + value2.name + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + value2.company_name + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + value2.phone + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + value2.pincode + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + value2.street1 + "<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" + value2.street2 + "</div>");
                });
            }
            if (response['user_info']['is_cod_enabled'] == true) {
                $('#iscod').removeClass('hidden');
                $('#stp').removeClass('hidden');
            }
        });


        $("#myModal").modal({
            backdrop: 'static',
            keyboard: false
        });
    });

    $(".proceed0").click(function () {
        $('.hds').remove();
        $('#stp').addClass('hidden');
        var data = $("#data").attr("value");
        var content = $('#content').attr('value');
        var array = content.split(',');

        var array1 = data.split(',');
        var j = 0;
        var count = $('#count').attr("value");

        var fixed_address = $('#fixed_address').attr("value");

        if(count > 1) {
            $('#newtwo').append('<div id="mps_alert"><span>There are more than 1 Items in this Order.' +
            'If you are plannning to send these items in a single Box, keep one entry & delete the others.</span></div>');
        }
        for (var i = 0; i < count; i++) {
            $("#newtwo").append("<form id='rates_form' name='rates_form'><div class='just'>" +
                "<div class='row'><h3 style='margin-left: 2%;'>Content - Line Item : <input required='required' type='text' value=" + array[i] + ">" +
                "<span class='rmv glyphicon glyphicon-trash' style='padding-left: 56%; cursor:pointer'></span></h3>" +
                "<div class='col-md-4'>" +
                "<div class='form-group'>" +
                "<label for=''>Length</label><br><input type='text' required='required' id='length' name='length' value='" + array1[j++] + "'>&nbsp;cm</div>" +
                "</div>" +
                "<div class='col-md-4'><div class='form-group'><label for=''>Width</label><br>" +
                "<input type='text' name='width' id='width' required='required' value='" + array1[j++] + "'>&nbsp;cm</div></div>" +
                "<div class='col-md-4'><div class='form-group'><label for=''>Height</label><br><input required='required' type='text' name='height' id='height' value='" + array1[j++] + "'>&nbsp;cm</div>" +
                "</div>" +
                "</div><div class='row'><div class='col-md-4'><div class='form-group'><label for=''>Weight</label><br><input type='text' required='required' name='weight' id='weight' value='" + array1[j++] + "'>&nbsp;gram</div>" +
                "</div><div class='col-md-4'><div class='form-group'><label for=''>Value</label><br>" +
                "<input type='text' required='required' id='value' name='value' value='" + array1[j++] + "'>&nbsp;Rs</div></div></div></div></form>")
        }


        if (count == '1') {
            $('.rmv').addClass('hidden');
        }
        $('#warehouses').addClass('hidden');
        $('#newtwo').removeClass('hidden');
        $('.proceed0').addClass('hidden');
        $('.proceed1').removeClass('hidden');
        $('.proceed0').prop('disabled', true);
    });

    $('#newtwo').off('click').on('click', '.rmv', function () {
        $(this).closest('.just').remove();
        var count = $('#count').attr("value");
        $('#count').attr("value", count - 1);
        if (count == '2') {
            $('.rmv').addClass('hidden');
        }
    });

    $(".proceed1").click(function () {
        var count = $('#count').attr("value");
        if (count == '1') {
            $('.rmv').addClass('hidden');
        }

        var array = $('input:text').map(function () {
            return this.value;
        }).get();
        var flag = 0;
        for (var i = 0; i < (count * 6); i++) {
            if (array[i] == "" || array[i] < 1) {
                alert("All the below Fields are mandatory for Shipping. Kindly configure the Weight & Dimensions against your Products for Smoother Shipping Selection");
                flag = 1;
                break;
            }
            flag = 0;
        }
        if (flag == 0) {
            var apikey = $("#custom_data").attr("key");
            var code = $("#custom_data").attr("code");
            var settings = {
                "async": true,
                "crossDomain": true,
                "url": "//" + code + "/api/v1/customers/info/",
                "method": "GET",
                "headers": {
                    "x-api-token": "" + apikey + "",
                    "content-type": "application/json",
                    "cache-control": "no-cache",
                }
            };

            $.ajax(settings).done(function (response) {
                var pickup_pincode = $('#pickup_pincode').attr('value');
                var is_cod = $("#is_cod").attr("value");
                var fixed_address = response['user_info'].fixed_address;
                $("#sender_primary_email").attr("value", response['user_info']['primary_email'][0]);
                $("#sender_primary_phone").attr("value", response['user_info']['primary_phone'][0]);


                $("#fixed_address").attr("value", fixed_address);
                var count = $('#count').attr("value");

                var contarr = new Array();
                var h = 0;
                for (var x = 0; x < count; x++) {
                    contarr[x] = array[h];
                    h = h + 6;
                }
                var parcel_content = contarr.join();
                $("#parcel_content").attr("value", parcel_content);
                var oid = $('.rtbtn').attr("oid");
                var delivery_pincode = $('#delivery_pincode').attr("value");

                var data = $('.rtbtn').attr("data");
                var fixed_address = $("#fixed_address").attr("value");
                var sender_company_name = $("#sender_company_name").attr("value");
                var sender_street1 = $("#sender_street1").attr("value");
                var sender_street2 = $("#sender_street2").attr("value");
                var sender_primary_city = $("#sender_primary_city").attr("value");
                var site_name = $('.rtbtn').attr("site_name");
                $("#site_name").attr("value", site_name);
                $("#count").attr("value", count);
                $("#pickup_pincode").attr("value", pickup_pincode);
                $("#order_id").attr("value", oid);
                $("#sender_name").html($("#sender_primary_contact").attr("value"));
                $("#sender_contact").html($("#sender_primary_phone").attr("value"));
                $("#sender_email").html($("#sender_primary_email").attr("value"));
                $("#sender_address").html("<p>" + sender_company_name + "<br>" + sender_street1 + "<br>" + sender_street2 + "<br>" + sender_primary_city + "&nbsp;" + pickup_pincode + "</p>");
                var j = 1;
                var i;
                var multiship = "{\n      \"length\": \"" + array[j++] + "\",\n      \"width\": \"" + array[j++] + "\",\n      \"height\": \"" + array[j++] + "\",\n      \"weight\": \"" + array[j++] + "\",\n      \"value\": \"" + array[j++] + "\"\n    }\n ";
                j++;
                for (i = 1; i < count; i++) {
                    multiship = multiship + "," + "{\n      \"length\": \"" + array[j++] + "\",\n      \"width\": \"" + array[j++] + "\",\n      \"height\": \"" + array[j++] + "\",\n      \"weight\": \"" + array[j++] + "\",\n      \"value\": \"" + array[j++] + "\"\n    }\n ";
                    j++;
                }
                var serviceEndpoint = "//" + code + "/api/v1/courier-services/domestic/";
                var receiver_country = $('#receiver_country').attr("value");
                if(receiver_country !== null && receiver_country !== undefined && !(receiver_country.toLowerCase() == 'in' || receiver_country.toLowerCase() == 'india')){
                    serviceEndpoint = "//" + code + "/api/v1/courier-services/international/";

                    delivery_pincode = COUNTRY_MAP_3_ISO[receiver_country.toUpperCase()];
                }

                var settings = {
                    "async": true,
                    "crossDomain": true,
                    "url": serviceEndpoint,
                    "method": "POST",
                    "headers": {
                        "x-api-token": "" + apikey + "",
                        "content-type": "application/json",
                        "cache-control": "no-cache"
                    },
                    "data": "{\n  \"delivery_pincode\": \"" + delivery_pincode + "\",\n  \"is_cod_booking\": " + is_cod + ",\n  \"is_commercial\": true,\n  \"is_document\": false,\n  \"need_insurance\": false,\n  \"packages\": [\n" + multiship + "  ],\n  \"pickup_pincode\": \"" + pickup_pincode + "\",\n  \"quantity\": \"" + count + "\"\n}"
                };

                $(".modal-body").remove("#getset");
                $.ajax(settings).done(function (response) {
                    $('#msg').addClass('hidden');
                    if (response['total_count'] == 0) {
                        $('#msg').removeClass('hidden');
                    }
                    $("#n1").empty();
                    $("#n2").empty();
                    $("#n3").empty();
                    $.each(response['services'], function (index, value) {
                        if (value.transit_time < 3) {
                            $('#n1').append("<div class='panel panel-success glow vendor-info'><div class='panel-body panel-spacing-red'><div class='col-md-12 result-top-row'><div class='col-md-8 clearfix'><img src='" + value.vendor_logo + "' style='width:100%;'></div><div class='col-md-4 item_price no-padding'><p class='text-right result-pricing' style='font-size:17px;line-height:13px'>" + "Rs." + (value.freight_charges + value.cod_charges) + "</p></div></div><div class='col-md-12 clearfix'><div class='col-md-12 result-service-name no-padding'><strong>" + value.vendor_name + "</strong> <span class='service-name' style='font-size: 9px;'><b><i>" + value.service_name + "</i></b></span></div></div><div class='col-md-12 clearfix'><hr class='no_top_hr'><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding'><p class='big-text text-center'>Book</p><p class='text-center'> Today by</p><p class='big-text text-center'>" + value.booking_cutoff + "</p></div></div><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding' rel='tooltip' data-toggle='tooltip' data-placement='top' title='' data-original-title=''><p class='big-text text-center'>Pick Up</p><p class='text-center'> Within next</p><p class='big-text text-center'> 48 hours </p><p></p></div></div><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding' rel='tooltip' data-toggle='tooltip' data-placement='top' title='' data-original-title=''><p class='big-text text-center'>Estimated Delivery <sup></sup></p><p class='text-center'> within</p><p class='big-text text-center'>" + value.transit_time + "&nbsp;" + "Days" + "</p></div></div><div class='col-md-3 no-padding feature-box '><div class='col-md-12 no-padding'><p class='big-text text-center printer' data-container='body' data-toggle='popover' data-trigger='focus' title='' data-placement='top' data-content='#Please note: this service includes a shipping label which will need to beprinted out and attached prior to collection. The Shipping label would be sent to the emailId used while booking. The Courier Company reserves all rights to reject shipments without the printed label.' data-original-title='Printer Required'>Printer Required<sup>#</sup></p></div></div></div><div class='col-md-12 clearfix feature-box no-padding'><hr class='no_top_hr'><div class='control-label col-md-12 col-xs-2 no-padding'><p class='big-text text-center'>Pay Online</p></div></div><div class='panel-footer col-md-12' style='padding: 0px 15px;'><a  oncontextmenu='return false;' value='" + value.product_id + "' class='item_add vendor-button btn btn-lg btn-block btn3d btn-danger add-cart-btn ashish1' >Book a Free Pickup</a></div></div></div>");
                        }
                        if (value.transit_time == 3) {
                            $('#n2').append("<div class='panel panel-success glow vendor-info'><div class='panel-body panel-spacing-red'><div class='col-md-12 result-top-row'><div class='col-md-8 clearfix'><img src='" + value.vendor_logo + "' style='width:100%;'></div><div class='col-md-4 item_price no-padding'><p class='text-right result-pricing' style='font-size:17px;line-height:13px'>" + "Rs." + (value.freight_charges + value.cod_charges) + "</p></div></div><div class='col-md-12 clearfix'><div class='col-md-12 result-service-name no-padding'><strong>" + value.vendor_name + "</strong> <span class='service-name' style='font-size: 9px;'><b><i>" + value.service_name + "</i></b></span></div></div><div class='col-md-12 clearfix'><hr class='no_top_hr'><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding'><p class='big-text text-center'>Book</p><p class='text-center'> Today by</p><p class='big-text text-center'>" + value.booking_cutoff + "</p></div></div><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding' rel='tooltip' data-toggle='tooltip' data-placement='top' title='' data-original-title=''><p class='big-text text-center'>Pick Up</p><p class='text-center'> Within next</p><p class='big-text text-center'> 48 hours </p><p></p></div></div><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding' rel='tooltip' data-toggle='tooltip' data-placement='top' title='' data-original-title=''><p class='big-text text-center'>Estimated Delivery <sup></sup></p><p class='text-center'> within</p><p class='big-text text-center'>" + value.transit_time + "&nbsp;" + "Days" + "</p></div></div><div class='col-md-3 no-padding feature-box '><div class='col-md-12 no-padding'><p class='big-text text-center printer' data-container='body' data-toggle='popover' data-trigger='focus' title='' data-placement='top' data-content='#Please note: this service includes a shipping label which will need to beprinted out and attached prior to collection. The Shipping label would be sent to the emailId used while booking. The Courier Company reserves all rights to reject shipments without the printed label.' data-original-title='Printer Required'>Printer Required<sup>#</sup></p></div></div></div><div class='col-md-12 clearfix feature-box no-padding'><hr class='no_top_hr'><div class='control-label col-md-12 col-xs-2 no-padding'><p class='big-text text-center'>Pay Online</p></div></div><div class='panel-footer col-md-12' style='padding: 0px 15px;'><a  oncontextmenu='return false;' value='" + value.product_id + "' class='item_add vendor-button btn btn-lg btn-block btn3d btn-danger add-cart-btn ashish1' >Book a Free Pickup</a></div></div></div>");
                        }
                        if (value.transit_time > 3) {
                            $('#n3').append("<div class='panel panel-success glow vendor-info'><div class='panel-body panel-spacing-red'><div class='col-md-12 result-top-row'><div class='col-md-8 clearfix'><img src='" + value.vendor_logo + "' style='width:100%;'></div><div class='col-md-4 item_price no-padding'><p class='text-right result-pricing' style='font-size:17px;line-height:13px'>" + "Rs." + (value.freight_charges + value.cod_charges) + "</p></div></div><div class='col-md-12 clearfix'><div class='col-md-12 result-service-name no-padding'><strong>" + value.vendor_name + "</strong> <span class='service-name' style='font-size: 9px;'><b><i>" + value.service_name + "</i></b></span></div></div><div class='col-md-12 clearfix'><hr class='no_top_hr'><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding'><p class='big-text text-center'>Book</p><p class='text-center'> Today by</p><p class='big-text text-center'>" + value.booking_cutoff + "</p></div></div><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding' rel='tooltip' data-toggle='tooltip' data-placement='top' title='' data-original-title=''><p class='big-text text-center'>Pick Up</p><p class='text-center'> Within next</p><p class='big-text text-center'> 48 hours </p><p></p></div></div><div class='col-md-3 no-padding feature-box'><div class='col-md-12 no-padding' rel='tooltip' data-toggle='tooltip' data-placement='top' title='' data-original-title=''><p class='big-text text-center'>Estimated Delivery <sup></sup></p><p class='text-center'> within</p><p class='big-text text-center'>" + value.transit_time + "&nbsp;" + "Days" + "</p></div></div><div class='col-md-3 no-padding feature-box '><div class='col-md-12 no-padding'><p class='big-text text-center printer' data-container='body' data-toggle='popover' data-trigger='focus' title='' data-placement='top' data-content='#Please note: this service includes a shipping label which will need to beprinted out and attached prior to collection. The Shipping label would be sent to the emailId used while booking. The Courier Company reserves all rights to reject shipments without the printed label.' data-original-title='Printer Required'>Printer Required<sup>#</sup></p></div></div></div><div class='col-md-12 clearfix feature-box no-padding'><hr class='no_top_hr'><div class='control-label col-md-12 col-xs-2 no-padding'><p class='big-text text-center'>Pay Online</p></div></div><div class='panel-footer col-md-12' style='padding: 0px 15px;'><a  oncontextmenu='return false;' value='" + value.product_id + "' class='item_add vendor-button btn btn-lg btn-block btn3d btn-danger add-cart-btn ashish1' >Book a Free Pickup</a></div></div></div>");
                        }
                    });
                    $("#newone").addClass('hidden');
                    $("#getset").removeClass('hidden');
                    $('.proceed1').addClass('hidden');
                    $('.proceed0').removeClass('hidden');

                }).error(function (err) {
                    alert("Proper inputs required!!!");
                });
            }).error(function (err) {
                alert("Proper inputs required!!!");
            });

        }


    });

    $('#getset').off('click').on('click', '.ashish1', function () {
        var product_id = $(this).attr("value");
        $("#product_id").attr("value", product_id);
        $("#getset").addClass('hidden');
        $("#next").removeClass('hidden');
        var receiver_name = $('#fname').attr("value") + " " + $('#lname').attr("value");
        $('#receiver_name').attr("value", receiver_name);
        var receiver_company = $('#receiver_company').attr('value');
        var receiver_shipadd1 = $('#receiver_shipadd1').attr('value');
        var receiver_shipadd2 = $('#receiver_shipadd2').attr('value');
        if(receiver_company === null || receiver_company === undefined || receiver_company === '' || receiver_company === ' ') {
            receiver_company = receiver_shipadd1;
            receiver_shipadd1 = receiver_shipadd2;
            receiver_shipadd2 = '';
        }
        $('#receiver_shipaddress').html("<span>Address Line 1 : &nbsp;</span> <input id='receiver_company1' style='width:60%;' type='text' value='" + receiver_company + "'><br> <span>Address Line 2 : &nbsp;</span> <input style='margin-left: 11%; width: 60%;' type='text' id='receiver_ship_add11' value='" + receiver_shipadd1 + "'><br><span>Address Line 3 : &nbsp;</span><input style='margin-left: 11%; width:60%;' type='text' id='receiver_ship_add22' value='" + receiver_shipadd2 + "'><br><span>" + $('#receiver_city').attr("value") + "</span>&nbsp;<span>" + $('#receiver_state').attr("value") + "</span>&nbsp;<span>" + $('#receiver_country').attr("value") + "</span>&nbsp;<span>" + $('#delivery_pincode').attr("value") + "</span>");
    });

    $("#new").click(function () {
        if ($(this).is(":checked")) {
            $("#new").attr("value", "1");
        } else {
            $("#new").attr("value", "0");
        }
    });

    $('#warehouses').off('click').on('click', '.addcheck', function () {

        $(".addcheck").removeClass("selected").addClass("unselected");
        $(this).removeClass("unselected").addClass("selected");
        $("#sender_company_name").attr("value", $(this).attr("pcompany_name"));
        $("#sender_street1").attr("value", $(this).attr("pstreet1"));
        $("#sender_street2").attr("value", $(this).attr("pstreet2"));
        $("#sender_primary_contact").attr("value", $(this).attr("name"));
        $("#sender_primary_phone").attr("value", $(this).attr("pphone"));
        $("#pickup_pincode").attr("value", $(this).attr("ppincode"));
        $('.proceed0').prop('disabled', false);

    });

    $(".proceed").click(function () {
        needsReload = true;

        var product_id = $("#product_id").attr("value");
        var code = $("#custom_data").attr("code");
        var apikey = $("#custom_data").attr("value");
        var receiver_name = $('#receiver_name').attr("value");
        var receiver_phone = $('#receiver_phone').attr("value");
        var receiver_email = $('#receiver_email').attr("value");
        var receiver_add = $('#receiver_add').attr("value");
        var parcel_content = $('#parcel_content').attr("value");
        var receiver_company = $('#receiver_company1').attr("value");
        var receiver_ship_add1 = $('#receiver_ship_add11').attr("value");
        var receiver_ship_add2 = $('#receiver_ship_add22').attr("value");
        var receiver_city = $('#receiver_city').attr("value");
        var receiver_state = $('#receiver_state').attr("value");
        var receiver_country = $('#receiver_country').attr("value");
        var receiver_pincode = $('#delivery_pincode').attr("value");
        // var receiver_phone = $('#receiver_phone').attr("value");
        var orderid = $('#oid').attr("value");
        var lblchk = $('#new').attr("value");
        var count = $("#count").attr("value");
        var pickup_pincode = $("#pickup_pincode").attr("value");
        var sender_company_name = $("#sender_company_name").attr("value");
        var sender_street1 = $("#sender_street1").attr("value");
        var sender_street2 = $("#sender_street2").attr("value");
        var sender_primary_contact = $("#sender_primary_contact").attr("value");
        var sender_primary_phone = $("#sender_primary_phone").attr("value");
        var sender_primary_email = $("#sender_primary_email").attr("value");
        var sender_primary_city = $("#sender_primary_city").attr("value");
        var site_name = $("#site_name").attr("value");
        var source = "woocommerce_plugin_" + site_name;
        var is_cod = $("#is_cod").attr("value");

        if(!sender_company_name) {
            sender_company_name = sender_street1;
            sender_street1 = sender_street2;
            sender_street2 = '';
        }

        if(!receiver_company) {
            receiver_company = receiver_ship_add1;
            receiver_ship_add1 = receiver_ship_add2;
            receiver_ship_add2 = '';
        }

        if (sender_street1 == "" || sender_street1.length < 2) {
            alert("Enter a Valid Receiver address Line 2!");
            return false;
        }
        if (sender_street1.length > 50) {
            alert("Address Line 2 exceeded maximum input length of 50 chars");
            return false;
        }
        
        if (sender_street2.length > 50) {
            alert("Address Line 3 exceeded maximum input length of 50 chars");
            return false;
        }
        if (receiver_company == "" || receiver_company.length < 2) {
            alert("Enter a Valid Receiver Address Line 1!");
            return false;
        }
        if (receiver_company.length > 50) {
            alert("Receiver Address Line 1 exceeded maximum input length of 50 chars!");
            return false;
        }
        if ($('#receiver_phone').attr('value') == "") {
            alert("Enter receiver contact number!!!");
            return false;
        }

        var ck;
        if (lblchk == "1") {
            ck = true;
        } else {
            ck = false;
            $("#dl").addClass('hidden');
            $("#gl").removeClass('hidden');
            $("#pdf").addClass('hidden');
            $("#cod_label").addClass('hidden');
        }
        var stat;
        if (count > 1) {
            stat = true;
        } else {
            stat = false;
        }
        var apikey = $("#custom_data").attr("key");
        var is_test_booking = $("#custom_data").attr("is_test_booking");
        if(is_test_booking === undefined || is_test_booking === null || is_test_booking === 'no' || is_test_booking == 0) {
            is_test_booking = false;
        };
        if(is_test_booking) {
            $('#is_test_mode').removeClass('hidden');
        }

        var settings = {
            "async": true,
            "crossDomain": true,
            "url": "//" + code + "/api/v2/bookings/",
            "method": "POST",
            "headers": {
                "X-API-Token": "" + apikey + "",
                "content-type": "application/json",
                "cache-control": "no-cache"
            },
            "data": JSON.stringify({
                "shipper": {
                    "name": sender_primary_contact,
                    "phone": sender_primary_phone,
                    "email": sender_primary_email,
                    "address": {
                        "company_name": sender_company_name,
                        "street1": sender_street1,
                        "street2": sender_street2,
                        "city": sender_primary_city,
                        "state": "",
                        "country": "india",
                        "postal_code": pickup_pincode
                    }
                },
                "receiver": {
                    "name": receiver_name,
                    "phone": receiver_phone,
                    "email": receiver_email,
                    "address": {
                        "company_name": receiver_company,
                        "street1": receiver_ship_add1,
                        "street2": receiver_ship_add2,
                        "city": receiver_city,
                        "state": receiver_state,
                        "country": receiver_country,
                        "postal_code": receiver_pincode
                    }
                },
                "customer_reference": orderid,
                // "invoice_number": "INVOICE_NUM",
                // "collect_on_delivery": 100.0,
                "product_id": product_id,
                "to_insure": false,
                "is_multi_packet_shipment": stat,
                "parcel_contents": parcel_content,
                "is_test_booking": is_test_booking,
                "send_confirmation_mail": true,
                "alert_receiver": true,
                "generate_label": ck,
                "order_source": source
            })

        };

        $.ajax(settings).done(function (response) {
            $.each(response['label_info'], function (index1, value1) {
                if (index1 == 'label') {
                    $('#pdf').html("<a href='" + value1.link + "' target='_blank' style='text-decoration:none;'>Download Label</a>");
                    $('#dl').attr("href", value1.link);
                    var str4 = "";
                    str4 = 'labellink=' + encodeURIComponent(value1.link) + '&orderid=' + $("#oid").val();
                    jQuery.ajax({
                        type: "POST",
                        data: str4,
                        success: function (data) {
                        }
                    });
                    if (count > 1) {
                        var awb = "";
                        var url = "";
                        $("#sp1").html("Its a multipackage shipment !!<br>");
                        $.each(value1.subpackages, function (index2, value2) {
                            $("#sp").append("<a href='" + value2.url + "' target='_blank' style='text-decoration:none;'>" + value2.awb + "</a><br>");
                            url = value2.url + "," + url;
                            awb = value2.awb + "," + awb;
                        });
                        awb = awb.slice(0, -1);
                        url = url.slice(0, -1);
                        var str9 = "";
                        str9 = 'package_awb=' + awb + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str9,
                            success: function (data) {
                            }
                        });
                        var str19 = "";
                        str19 = 'subpackages_label=' + encodeURIComponent(url) + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str19,
                            success: function (data) {
                            }
                        });
                    }
                    if (value1.cod_label != null && value1.cod_label !== undefined && value1.cod_label !== "") {
                        var str10 = "";
                        str10 = 'cod_label=' + encodeURIComponent(value1.cod_label) + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str10,
                            success: function (data) {
                            }
                        });
                        $('#cod_label').html("<a href='" + value1.cod_label + "' target='_blank' style='text-decoration:none;'>Download COD label</a>");
                        $("#cod_label").removeClass('hidden');
                    }
                }
            });
            $.each(response['booking'], function (index, value) {
                $('#book_id').html(value.booking_id);
                $('#book_id').attr("value", value.booking_id);
                if (value.tracking_number !== null) {
                    $('#track_id').html("<p>Tracking id : &nbsp;<span>" + value.tracking_number + "</span></p>");
                }
                var str1 = "";
                str1 = 'eczid=' + value.booking_id + '&orderid=' + $("#oid").val() + '&trackid=' + value.tracking_number;
                jQuery.ajax({
                    type: "POST",
                    data: str1,
                    success: function (data) {
                    }
                });
            });
            $("#bsuccess").removeClass('hidden');
            $("#next").addClass('hidden');
            $("#booked").removeClass('hidden');
            var str = "";
            str = 'labelstatus=' + $("#new").val() + '&orderid=' + $("#oid").val() + '&bookingstatus=' + "1";
            jQuery.ajax({
                type: "POST",
                data: str,
                success: function (data) {
                }
            });
        }).fail(function (jqXHR, textStatus, errorThrown) {
            if(402 == jqXHR.status) {
                alert("Your eCourierz Wallet has insufficient Balance to Make this Booking. Kindly Recharge your Wallet to proceed with this Booking");
            }
            else {
                alert("Kindly check whether all the fields are filled in.")
            }
        });
    });

    $("#gl").off('click').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var eczid = $('#book_id').attr("value");
        var is_cod = $("#is_cod").attr("value");
        var apikey = $("#custom_data").attr("key");
        var code = $("#custom_data").attr("code");
        var settings = {
            "async": true,
            "crossDomain": true,
            "url": "//" + code + "/api/v2/labels/" + eczid + "/",
            "method": "GET",
            "headers": {
                "x-api-token": "" + apikey + "",
                "cache-control": "no-cache"
            }
        };
        $.ajax(settings).done(function (response) {
            $.each(response['labels'], function (index, value) {
                $.each(value['label'], function (index1, value1) {
                    if (index1 == 'link') {
                        $('#pdf').html("<a href='" + value1 + "' target='_blank' style='text-decoration:none;'>Download Label</a>");
                        $('#dl').attr("href", value1);
                        var str2 = "";
                        str2 = 'labellink=' + encodeURIComponent(value1) + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str2,
                            success: function (data) {
                            }
                        });
                    }
                    if (index1 == 'subpackages') {
                        var awb = "";
                        var url = "";
                        $("#sp1").html("Its a multipackage shipment !!<br>");
                        $.each(value1, function (index2, value2) {
                            $("#sp").append("<a href='" + value2.url + "' target='_blank' style='text-decoration:none;'>" + value2.awb + "</a><br>");
                            url = value2.url + "," + url;
                            awb = value2.awb + "," + awb;
                        });
                        awb = awb.slice(0, -1);
                        url = url.slice(0, -1);
                        var str8 = "";
                        str8 = 'package_awb=' + awb + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str8,
                            success: function (data) {
                            }
                        });
                        var str18 = "";
                        str18 = 'subpackages_label=' + encodeURIComponent(url) + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str18,
                            success: function (data) {
                            }
                        });
                    }
                    if (index1 == 'tracking_number') {
                        $('#track_id').html("<p>Tracking id : &nbsp;<span>" + value1 + "</span></p>");
                        var str3 = "";
                        str3 = 'trackid=' + value1 + '&orderid=' + $("#oid").val();
                        jQuery.ajax({
                            type: "POST",
                            data: str3,
                            success: function (data) {
                            }
                        });
                    }
                    if (index1 == 'cod_label') {
                        if (value1 != null) {
                            var str13 = "";
                            str13 = 'cod_label=' + encodeURIComponent(value1) + '&orderid=' + $("#oid").val();
                            jQuery.ajax({
                                type: "POST",
                                data: str13,
                                success: function (data) {
                                }
                            });
                            $('#cod_label').html("<a href='" + value1 + "' target='_blank' style='text-decoration:none;'>Download COD label</a>");
                            $("#cod_label").removeClass('hidden');
                        }

                    }
                });
            });
            $("#dl").removeClass('hidden');
            $("#pdf").removeClass('hidden');
        }).error(function (err) {
            alert("Proper inputs required!!!");
        });
        $("#gl").addClass('hidden');
        $("#bsuccess").addClass('hidden');
        location.reload();
    });

    $("#dl").click(function () {
        var str5 = "";
        str5 = 'orderid=' + $("#oid").val();
        jQuery.ajax({
            type: "POST",
            data: str5,
            success: function (data) {
            }
        });
    });

    $(".glabelbtn").click(function () {
        $("#newone").addClass('hidden');
        var eczid = $(this).attr("value");
        var orderid = $(this).attr("oid");
        $("#book_id").html(eczid);
        var apikey = $("#custom_data").attr("key");
        var code = $("#custom_data").attr("code");
        var settings = {
            "async": true,
            "crossDomain": true,
            "url": "//" + code + "/api/v1/labels/" + eczid + "/",
            "method": "GET",
            "headers": {
                "x-api-token": "" + apikey + "",
                "cache-control": "no-cache"
            }
        };
        $.ajax(settings).done(function (response) {
            $.each(response['labels'], function (index, value) {
                $.each(value['label'], function (index1, value1) {
                    if (index1 == 'link') {
                        $('#pdf').html("<a href='" + value1 + "' target='_blank' style='text-decoration:none;'>Download Label</a>");
                        $('#dl').attr("href", value1);
                        var str6 = "";
                        str6 = 'labellink=' + encodeURIComponent(value1) + '&orderid=' + orderid;
                        jQuery.ajax({
                            type: "POST",
                            data: str6,
                            success: function (data) {
                            }
                        });
                    }
                    if (index1 == 'cod_label') {
                        if (value1 != null) {
                            var str11 = "";
                            str11 = 'cod_label=' + encodeURIComponent(value1) + '&orderid=' + orderid;
                            jQuery.ajax({
                                type: "POST",
                                data: str11,
                                success: function (data) {
                                }
                            });
                            $('#cod_label').html("<a href='" + value1 + "' target='_blank' style='text-decoration:none;'>Download COD label</a>");
                            $("#cod_label").removeClass('hidden');
                        }

                    }
                    if (index1 == 'subpackages') {
                        var awb = "";
                        var url = "";
                        $("#sp1").html("Its a multipackage shipment !!<br>");
                        $.each(value1, function (index2, value2) {
                            $("#sp").append("<a href='" + value2.url + "' target='_blank' style='text-decoration:none;'>" + value2.awb + "</a><br>");
                            url = value2.url + "," + url;
                            awb = value2.awb + "," + awb;
                        });
                        awb = awb.slice(0, -1);
                        url = url.slice(0, -1);
                        var str8 = "";
                        str8 = 'package_awb=' + awb + '&orderid=' + orderid;
                        jQuery.ajax({
                            type: "POST",
                            data: str8,
                            success: function (data) {
                            }
                        });
                        var str28 = "";
                        str28 = 'subpackages_label=' + encodeURIComponent(url) + '&orderid=' + orderid;
                        jQuery.ajax({
                            type: "POST",
                            data: str28,
                            success: function (data) {
                            }
                        });
                    }
                    if (index1 == 'tracking_number') {
                        $('#track_id').html("<p>Tracking id : &nbsp;<span>" + value1 + "</span></p>");
                        var str7 = "";
                        str7 = 'trackid=' + value1 + '&orderid=' + orderid;
                        jQuery.ajax({
                            type: "POST",
                            data: str7,
                            success: function (data) {
                            }
                        });
                    }
                });
            });
            $("#dl").removeClass('hidden');
            $("#gl").addClass('hidden');
            $("#pdf").removeClass('hidden');
        }).error(function (err) {
            alert("Proper inputs required!!!");
        });
        $("#getset").addClass('hidden');
        $("#next").addClass('hidden');
        $("#details").addClass('hidden');
        $("#booked").removeClass('hidden');
        $("#bsuccess").addClass('hidden');
        $("#myModal").modal({
            backdrop: 'static',
            keyboard: false
        });
    });

    $(".detailbtn").click(function () {
        $(".trow").remove();
        $("#newone").addClass('hidden');
        var count = $(this).attr("count");
        var awbs = $(this).attr("awb");
        var urls = $(this).attr("url");
        var is_cod = $("#is_cod").attr("value");
        var cod_label = $(this).attr("cod_label");
        var label_link = $(this).attr("label_link");


        if (awbs.length > 0) {
            var array = awbs.split(',');
            var array1 = urls.split(',');
            $("#thead").html("<tr class='trow'><td>Sr no.</td><td>AWB no.</td><td>Download Labels</td></tr>");
            $("#awb").html("<p class='trow'>Multi package shipment</p>");
            for (var i = 0; i < array.length; i++) {
                $("#awb_no").append("<tr class='trow'><td>" + (i + 1) + "</td><td>" + array[i] + "</td><td><a href='" + array1[i] + "' target='_blank' style='text-decoration:none;'>Download</a></td></tr>");
            }
        }
        
        if (cod_label != null && cod_label != undefined && cod_label !== '' && cod_label != 'null') {
            $("#clbdown").html("<a href='" + cod_label + "' target='_blank' style='text-decoration:none;'>Download COD label</a>");
        }

        $("#det").html("<p>Booking id :&nbsp; <span>" + $(this).attr('bookingid') + "</span></p><br><p>Tracking no : &nbsp;<span>" + $(this).attr('trackno') + "</span></p>");
        $("#lbdown").html("<a href='" + label_link + "' target='_blank' style='text-decoration:none;'>Download label</a>");
        $("#getset").addClass('hidden');
        $("#next").addClass('hidden');
        $("#booked").addClass('hidden');
        $("#details").removeClass('hidden');
        $("#myModal").modal({
            backdrop: 'static',
            keyboard: false
        });
    });

    $('.ecz_order').off('click').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $("#trackingModal").modal({
            backdrop: 'static',
            keyboard: false
        });
        var order_id = $(this).attr('ecz_ref');
        var code = $(this).attr('code1');
        var key = $(this).attr('key1');
        var ezid = $('#ezid');
        var settings = {
            "async": true,
            "crossDomain": true,
            "url": "//"+code+"/api/v1/tracking/",
            "method": "POST",
            "headers": {
                "x-api-token": key,
                "content-type": "application/json",
                "cache-control": "no-cache",
            },
            "processData": false,
            "data": "{\"order_ids\": \""+order_id+"\"}"  
        };
        $.ajax(settings).done(function (response) {	
            var eczid = response.tracking_details[0].order_id;
            document.getElementById("ezid").innerHTML = response.tracking_details[0].order_id;
            document.getElementById("slug").innerHTML = response.tracking_details[0].slug;
            document.getElementById("track_no").innerHTML = response.tracking_details[0].tracking_number;
            var txt="";
            for (i in response.tracking_details[0].checkpoints) {
                txt += '<div class="col-md-12 row">';
                txt += '<div class="col-md-6">';
                if(response.tracking_details[0].checkpoints[i].checkpoint_time) {
                    txt += response.tracking_details[0].checkpoints[i].checkpoint_time;
                }
                else {
                    txt += ' - ';
                }
                txt += "</div>";
                txt += '<div class="col-md-6">';
                txt += response.tracking_details[0].checkpoints[i].message;
                txt += "</div><hr>";
                txt += "</div>";
            }
            document.getElementById("checkpoints").innerHTML = txt;
        });
        return false;
    });
    
});

jQuery(function ($) {
    $("#back").click(function () {
        $("#next").addClass('hidden');
        $("#getset").removeClass('hidden');
    });

    $("#back1").click(function () {
        $("#next").addClass('hidden');
        $("#newone").removeClass('hidden');
    });
    
    $(document).ajaxStart(function () {
        $("#loading").removeClass('hidden');
    }).ajaxStop(function () {
        $("#loading").addClass('hidden');
    });

});
