<?php
/*
Plugin Name: Payment Gateway
Plugin URI: http://merchant.apnamshop.com/
Description: Extends WooCommerce by Adding the Paynetz Gateway.
Version: 1.0
Author: ApnaMShop
Author URI: http://merchant.apnamshop.com/
*/
 
// Include our Gateway Class and register Payment Gateway with WooCommerce
add_action( 'plugins_loaded', 'woocommerce_atom_init', 0 );
define('IMGDIR', WP_PLUGIN_URL . "/" . plugin_basename(dirname(__FILE__)) . '/assets/img/');

function woocommerce_atom_init() {
    // If the parent WC_Payment_Gateway class doesn't exist
    // it means WooCommerce is not installed on the site
    // so do nothing
    if ( ! class_exists( 'WC_Payment_Gateway' ) ) return; 
    // If we made it this far, then include our Gateway Class
    class WC_Gateway_Atom extends WC_Payment_Gateway {
		
    // Setup our Gateway's id, description and other values
    function __construct() {
		global $woocommerce;
		global $wpdb;
		$this->id = "atom";
		$this->icon = IMGDIR . 'logo.png';
        $this->method_title = __( "Online Payment", 'wc_gateway_atom' );
        $this->method_description = "Online Payment setting page.";
        $this->title = __( "Online Payment", 'wc_gateway_atom' );
		$this->has_fields = false;
		$this->init_form_fields();
		$this->init_settings();
		$this->url 				= $this->settings['atom_domain'];
		$this->atom_port		= $this->settings['atom_port'];
		$this->login_id 		= $this->settings['login_id'];
		$this->password 		= $this->settings['password'];
		$this->description 		= $this->settings['description'];
		$this->atom_product_id  = $this->settings['atom_prod_id'];
		$this->req_hash_code = $this->settings['req_hash_code'];
        $this->res_hash_code = $this->settings['res_hash_code'];

        add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
		if(isset($woocommerce->cart)){
			$checkout_url = $woocommerce->cart->get_checkout_url();
			$this->notify_url = $checkout_url;
		}
		$this->check_atom_response();
	
		// include_once("cron_validate.php");
		
		// $res= revalidate_cron();
		
		// print_r($res);exit;
	
		/*  add_filter('cron_schedules', 'new_intervals');

		// add once 30 minute interval to wp schedules
		function new_intervals($interval) {

			$interval['minutes_30'] = array('interval' => 30*60, 'display' => 'Once 30 minutes');

			return $interval;
		} 
		
		function InitiateMyCron() {
			wp_schedule_event(time(), 'minutes_30', 'update_ransaction_status');
		} */
		 
		// $this->wc_suc_unpaid_orders();
	}
	
	public function update_ransaction_status() {
		
		// echo"hmmm";exit;
		
		global $wpdb;
		$held_duration = get_option( 'woocommerce_hold_stock_minutes' );
		
		// print_r()
	
		if ( $held_duration < 1 || get_option( 'woocommerce_manage_stock' ) != 'yes' )
			return;

		$date = date( "Y-m-d H:i:s", strtotime( '-' . absint( 0 ) . ' MINUTES', current_time( 'timestamp' ) ) );

		$unpaid_orders = $wpdb->get_results( $wpdb->prepare( "
			SELECT posts.ID, postmeta.meta_key, postmeta.meta_value, posts.post_modified
			FROM {$wpdb->posts} AS posts
			RIGHT JOIN {$wpdb->postmeta} AS postmeta ON posts.id=postmeta.post_id
			WHERE 	posts.post_type   IN ('" . implode( "','", wc_get_order_types() ) . "')
			AND 	posts.post_status = 'wc-pending'
			AND 	posts.post_modified + INTERVAL 10 MINUTE < %s
		", $date ) );
		 
		$pending_array='';
		foreach($unpaid_orders as $value){
			if($value->meta_key=='_order_total'){
				$pending_array[]=$value;
			}
		}
		echo $pending_array;exit;
		if(!empty($pending_array)){
			$response_URL 	=	"https://paynetzuat.atomtech.in/paynetz/vfts";
			$this->atom_port		= $this->settings['atom_port'];
			foreach($pending_array as $val){
				$mer_txn=$val->ID;
				$amt=$val->meta_value;
				$date = date("Y-m-d", strtotime($val->post_modified));
				$merchant_id=160;
			
			 	$param = "?merchantid=".$merchant_id."&merchanttxnid=".$mer_txn."&amt=".$amt."&tdate=".$date;
				
				$ch = curl_init();
				$useragent = 'woo-commerce plugin';
				curl_setopt($ch, CURLOPT_URL, $response_URL);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_PORT , 443);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
				curl_setopt($ch, CURLOPT_USERAGENT, $useragent);;
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				//information received from gateway is stored in $response.
				$response = curl_exec($ch);
				
				if(curl_errno($ch))
				{	
					echo '<div class="woocommerce-error">Curl error: "'. curl_error($ch).". Error in gateway credentials.</div>";
					die;
				}
				curl_close($ch);
				
				$parser = xml_parser_create('');
				xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8");
				xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
				xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
				xml_parse_into_struct($parser, trim($response), $xml_values);
				xml_parser_free($parser);
				$result_resp=$xml_values[0]['attributes']['VERIFIED'];
				
				$unpaid_order=$mer_txn;
				if ( $unpaid_order ) {
						$order = wc_get_order( $unpaid_order );
						if ( apply_filters( 'woocommerce_cancel_unpaid_order', 'checkout' === get_post_meta( $unpaid_order, '_created_via', true ), $order ) ) {
							if($result_resp=='SUCCESS'){
								$order->update_status( 'completed', __( 'Unpaid order completed - time limit reached.', 'woocommerce' ) );
							}
						}
				}
			}
		}
	}
	
  // Build the administration fields for this specific Gateway
    public function init_form_fields() {
       $this->form_fields = array(
                'enabled' => array(
                 //   'title'         => __('Enable/Disable', 'wc_gateway_atom'),
                    'type'             => 'checkbox',
                    'label'         => __('Enable Online Payment Module.', 'wc_gateway_atom'),
                    'default'         => 'no',
                    'description'     => 'Show in the Payment List as a payment option'
                ),
                  'title' => array(
                    'title'         => __('Title:', 'wc_gateway_atom'),
                    'type'            => 'text',
                    'default'         => __('Pay Online', 'wc_gateway_atom'),
                    'description'     => __('This controls the title which the user sees during checkout.', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
                'description' => array(
                    'title'         => __('Description:', 'wc_gateway_atom'),
                    'type'             => 'textarea',
                    'default'         => __("Pay securely by Credit or Debit Card or Internet Banking through Secure Servers."),
                    'description'     => __('This controls the description which the user sees during checkout.', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
                'atom_domain' => array(
                    'title'         => __('Specify Domain', 'wc_gateway_atom'),
                    'type'             => 'text',
                    'description'     => __('Will be provided by Atom Paynetz Team after production movement', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
                'login_id' => array(
                    'title'         => __('Login Id', 'wc_gateway_atom'),
                    'type'             => 'text',
                    'description'     => __('As provided by Atom Paynetz Team', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
                'password' => array(
                    'title'         => __('Password', 'wc_gateway_atom'),
                    'type'             => 'password',
                    'description'     => __('As provided by Atom Paynetz Team', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
                'atom_prod_id'     => array(
                    'title'         => __('Product ID', 'wc_gateway_atom'),
                    'type'             => 'text',
                    'description'     =>  __('Will be provided by Atom Paynetz Team after production movement', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
				'atom_port'     => array(
                    'title'         => __('Port Number', 'wc_gateway_atom'),
                    'type'             => 'text',
                    'description'     =>  __('80 for Test Server & 443 for Production Server', 'wc_gateway_atom'),
                    'desc_tip'         => true
                ),
               'req_hash_code'     => array(
                   'title'         => __('Request Hashcode', 'wc_gateway_atom'),
                   'type'             => 'text',
                   'description'     =>  __('Request hash code, provided by Atom', 'wc_gateway_atom'),
                   'desc_tip'         => true
               ),
               'res_hash_code'     => array(
                   'title'         => __('Response Hashcode', 'wc_gateway_atom'),
                   'type'             => 'text',
                   'description'     =>  __('Response hash code, provided by Atom', 'wc_gateway_atom'),
                   'desc_tip'         => true
               ),
            );
	 }

        private function validateResponse($responseParams)
        {
            $str = $responseParams["mmp_txn"].$responseParams["mer_txn"].$responseParams["f_code"].$responseParams["prod"].$responseParams["discriminator"].$responseParams["amt"].$responseParams["bank_txn"];
            $signature =  hash_hmac("sha512",$str,$this->res_hash_code,false);
            //$signature = "123";
            if($signature == $responseParams["signature"]){
                return true;
            } else {
                return false;
            }

        }

    function check_atom_response(){
		global $woocommerce;
		 global $wpdb, $woocommerce;
        if(isset($_REQUEST['f_code']) && $this->validateResponse($_REQUEST)){
			$order = new WC_Order($_REQUEST['mer_txn']);
			//var_dump($order); exit;
			$order_id = $_REQUEST['mer_txn'];
			$VERIFIED		=	$_REQUEST['f_code'];
			if($VERIFIED == 'Ok'){
				$VERIFIED = 'processing';
			}else{
				$VERIFIED = 'pending';
			}
			
			$bank_name		=	$_REQUEST['bank_name'];
			$bank_txn		=	$_REQUEST['bank_txn'];
			$discriminator	=	$_REQUEST['discriminator'];
			
			if($_REQUEST['f_code']=='Ok'){
				$order->update_status('processing');
				$this -> msg['message'] = "Thank you for shopping with us. Your account has been charged <b>Rs".$_REQUEST['amt']."</b> for order id <b>".$order_id."</b> and your transaction is successful. Bank Transaction ID is  : <b>".$_REQUEST['bank_txn']."</b>.";
                $this->msg['class'] = 'woocommerce-message';
				$this->msg['order'] = $order;
            } else {
				$order->update_status('failed');
                $this->msg['class'] = 'woocommerce-error';
				$this->msg['message'] = "Thank you for shopping with us. However, the transaction has been declined.";
            }
			add_action('the_content', array(&$this, 'showMessage'));
				
			add_filter('cron_schedules', 'new_intervals');
			function new_intervals($interval) {

				$interval['minutes_30'] = array('interval' => 30*60, 'display' => 'Once 30 minutes');

				return $interval;
			}
			function InitiateMyCron() {
				wp_schedule_event(time(), 'minutes_30', 'update_ransaction_status');
			}
				
        } else {

				//$order->update_status('failed');
                		$this->msg['class'] = 'woocommerce-error';
				$this->msg['message'] = "Thank you for shopping with us. However, the transaction has been declined.";
				add_action('the_content', array(&$this, 'showErrMessage'));

        }
    }

    function showErrMessage($content){
        $cont = '';
        $cont .= '<div class="woocommerce">';
        $cont .= '<p>'.$this->msg['message'].$content.'</p></div>';
        return $cont;

    }
	function showMessage($content){
       $cont = '';
	   
	   $cont .= '<div class="woocommerce">
	
				<p>'.$this->msg['message'].$content.'</p>

				<ul class="order_details">
					<li class="order">
						Order Number:				<strong>'.$this->msg['order']->get_order_number().'</strong>
					</li>
					<li class="date">
						Date:				<strong>'.date_i18n( get_option( 'date_format' ), strtotime( $this->msg['order']->order_date ) ).'</strong>
					</li>
					<li class="total">
						Total:				<strong><span class="amount">'.$this->msg['order']->get_formatted_order_total().'</span></strong>
					</li>
								<li class="method">
						Payment Method:				<strong>'.$this->msg['order']->payment_method_title.'</strong>
					</li>
							</ul>
				<div class="clear"></div>

			
			<p>Pay with cash upon delivery.</p>
			<h2>Order Details</h2>
		<table class="shop_table order_details">
			<thead>
				<tr>
					<th class="product-name">Product</th>
					<th class="product-total">Total</th>
				</tr>
			</thead>
			<tbody>';
			
		$order_items = $this->msg['order']->get_items();
		$total = 0.00;
		foreach( $order_items as $product ) 
		{
		$cont .= '<tr class="order_item">
					<td class="product-name">'. $product['name'] .' <strong class="product-quantity">x '. $product['qty'] .'</strong>	</td>
					<td class="product-total">
						<span class="amount">Rs. '. $product['line_subtotal'] .' </span>	</td>
				</tr>';
				
			$total += $product['line_subtotal'];
		}	
	$cont .= '</tbody>
				<tfoot>';
					
						foreach ( $this->msg['order']->get_order_item_totals() as $total ) {
						
			$cont .= '		<tr>
								<th scope="row">'. $total['label'] .'</th>
								<td>'. $total['value'] .'</td>
							</tr>';
						
						}
					
	$cont .= '	</tfoot>
		</table>


		<header><h2>Customer Details</h2></header>

		<table class="shop_table shop_table_responsive customer_details">
			
			<tbody>';
			
				if ( $this->msg['order']->customer_note ) :
	$cont .= '	<tr>
					<th>Note:</th>
					<td>'. esc_html( $this->msg['order']->customer_note ) .'</td>
				</tr>';
				endif;
			
				if ( $this->msg['order']->billing_email ) :
	$cont .= '	<tr>
					<th>Email:</th>
					<td>'. esc_html( $this->msg['order']->billing_email ) .'</td>
				</tr>';
				endif;
	if ( $this->msg['order']->billing_phone ) :
	$cont .= '	<tr>
					<th>Telephone:</th>
					<td>'. esc_html( $this->msg['order']->billing_phone ) .'</td>
				</tr>';
				endif;
			
	$cont .= '
			</tbody>
		</table>


		<header class="title">
			<h3>Billing Address</h3>
		</header>
		<address>';
	$cont .= ( $address = $this->msg['order']->get_formatted_shipping_address() ) ? $address : 'N/A';
	$cont .= '
			</address>
		</div>';
	   
	   return $cont;
    }

        private function getChecksum($data){
            $amt = $data['amt'];
            //$amt = $amt.".00";
            $str = $data['login'] . $data['pass'] . "NBFundTransfer" . $data['prodid'] . $data['txnid'] . $amt . "INR";
            $signature =  hash_hmac("sha512",$str,$data['reqHashCode'],false);
            return $signature;
        }

        // Submit payment and handle response
    public function process_payment( $order_id ) {
		


		
		global $woocommerce;
		global $current_user;
		//get user details   
		$current_user	= wp_get_current_user();
            
		$user_email     = $current_user->user_email;
		$first_name     = $current_user->shipping_first_name;
		$last_name      = $current_user->shipping_last_name;
		$phone_number   = $current_user->billing_phone;
		$country       	= $current_user->shipping_country;
		$state       	= $current_user->shipping_state;
		$city       	= $current_user->shipping_city;
		$postcode       = $current_user->shipping_postcode;
		$address_1      = $current_user->shipping_address_1;
		$address_2      = $current_user->shipping_address_2;
		$udf1 			= $first_name." ".$last_name;
		$udf2			= $user_email;
		$udf3			= $phone_number;
		$udf4			= $country." ".$state." ".shipping_city." ".$address_1." ".$address_2." ".$postcode;

		//if($user_email == ''){
			$user_email 	= $_POST['billing_email'];
			$first_name 	= $_POST['billing_first_name'];
			$last_name  	= $_POST['billing_last_name'];
			$phone_number 	= $_POST['billing_phone'];
			$country       	= $_POST['billing_country'];
			$state       	= $_POST['billing_state'];
			$city       	= $_POST['billing_city'];
			$postcode       = $_POST['billing_postcode'];
			$address_1      = $_POST['billing_address_1'];
			$address_2      = $_POST['billing_address_2'];
			$udf1 		= $first_name." ".$last_name;
			$udf2		= $user_email;
			$udf3		= $phone_number;
			$udf4		= $country." ".$state." ".shipping_city." ".$address_1." ".$address_2." ".$postcode;
		//}

		$order 			= new WC_Order( $order_id );
		$atom_login_id 	= $this->login_id;
        $atom_password 	= $this->password;
        $atom_prod_id 	= $this->atom_product_id;
        $amount 		= $order->get_total();
        $currency 		= "INR";
        $custacc 		= "1234567890";
        $txnid 			= $order_id;    
        $clientcode 	= urlencode(base64_encode(007));
        $datenow 		= date("d/m/Y h:m:s");
        $encodedDate 	= str_replace(" ", "%20", $datenow);
        $ru 			= $this->notify_url;


        $data["login"] = $atom_login_id;
        $data["pass"] = $atom_password;
        $data["prodid"] = $atom_prod_id;
        $data['txnid']=$txnid;
        $data['amt'] = $amount;
        $data['reqHashCode'] = $this->req_hash_code;
        //print_r($data);exit;
        $signature = $this->getChecksum($data);

       $param = "login=".$atom_login_id."&pass=".$atom_password."&ttype=NBFundTransfer"."&prodid=".$atom_prod_id."&amt=".$amount."&txncurr=".$currency."&txnscamt=0"."&clientcode=".$clientcode."&txnid=".$txnid."&date=".$encodedDate ."&custacc=".$custacc."&udf1=".$udf1."&udf2=".$udf2."&udf3=".$udf3."&udf4=".$udf4."&ru=".$ru;
	   $param = $param."&signature=".$signature;

	   global $wpdb, $woocommerce;

	   //echo $this->url.$param ;exit;
	   
	   /* $ch = curl_init();
        $useragent = 'woo-commerce plugin';	
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_PORT , $this->atom_port);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
		curl_setopt($ch, CURLOPT_SSLVERSION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);	
		
        // information received from gateway is stored in $response.
        $response = curl_exec ($ch);
		
		if(curl_errno($ch))
        {	
            echo '<div class="woocommerce-error">Curl error: "'. curl_error($ch).". Error in gateway credentials.</div>";
			die;
        }
        curl_close($ch);
        $parser = xml_parser_create('');
        xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, "UTF-8");
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
        xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
        xml_parse_into_struct($parser, trim($response), $xml_values);
        xml_parser_free($parser);

        $returnArray = array();
        $returnArray['url'] = $xml_values[3]['value'];
        $returnArray['tempTxnId'] = $xml_values[5]['value'];
        $returnArray['token'] = $xml_values[6]['value'];    
		
		//code to generate form action
        $xmlObjArray = $returnArray;
		$url = $xmlObjArray['url'];
		
		$postFields  = "";
        $postFields .= "&ttype=NBfundTransfer";
        $postFields .= "&tempTxnId=".$xmlObjArray['tempTxnId'];
        $postFields .= "&token=".$xmlObjArray['token'];
        $postFields .= "&txnStage=1";
        $q = $url."?".$postFields;*/
		
		return array('result' => 'success', 'redirect' => $this->url."?" .$param);
		exit;
    }
}
	
    // Now that we have successfully included our class,
    // Lets add it too WooCommerce
    add_filter( 'woocommerce_payment_gateways', 'add_atom_gateway' );
    function add_atom_gateway( $methods ) {
        $methods[] = 'WC_Gateway_Atom';
		return $methods;
	}
}